%% Ozone
[ozonedata, ozoneinfo] = ARM_CDF_Import('E:\Google Drive\Projects\HI-SCALE SGP\Data\ARM_Data\ozone');

% Removing bad data.  less than 0, and the ten minutes after midnight and noon
ozonedata.o3(ozonedata.o3 < 0) = NaN;
ozonedata.o3(ozonedata.time <= 600) = NaN;
ozonedata.o3(ozonedata.time >= 43200 & ozonedata.time <= 43800) = NaN;

[ozonedata.avgtime, ozonedata.avgo3] = RollingAverage(ozonedata.realtime,ozonedata.o3,600);
ozonedata.avgo3filt = medfilt1(ozonedata.avgo3);

ozonedata.avgtime_cdt = datetime(datevec(ozonedata.avgtime) - [0,0,0,5,0,0]);

ozonedata2.avgtime = ozonedata.avgtime;
ozonedata2.avgtime_cdt = ozonedata.avgtime_cdt;
ozonedata2.avgo3filt = ozonedata.avgo3filt;
clear ozonedata ozoneinfo


%% Sulfer dioxide
[so2data, so2info] = ARM_CDF_Import('E:\Google Drive\Projects\HI-SCALE SGP\Data\ARM_Data\SO2');

bigzerodays = [29, 6, 13];
so2data.datevec = datevec(so2data.realtime);
so2data.so2(so2data.time < 600) = NaN;
so2data.so2(ismember(so2data.datevec(:,3),bigzerodays) & so2data.datevec(:,4) == 0 & so2data.datevec(:,5) < 18) = NaN;

so2_badbits = [1,2,3,16,17,18,19,22,23,24,25];
for so2bits_idx = 1:length(so2_badbits)
	so2data.so2(bitget(so2data.qc_so2,ones(size(so2data.qc_so2)).*so2_badbits(so2bits_idx)) == 1) = NaN;
	
end


[so2data.avgtime,so2data.avgso2] = RollingAverage(so2data.realtime,so2data.so2,600);
so2data.filtavgso2 = medfilt1(so2data.avgso2);

so2data.filtavgso2 = so2data.filtavgso2 + abs(min(so2data.filtavgso2));

so2_xvals = 1:length(so2data.filtavgso2);
so2data.filtavgso2 = interp1(so2_xvals, so2data.filtavgso2, so2_xvals, 'pchip');

so2data.avgtime_cdt = datetime(datevec(so2data.avgtime) - [0,0,0,5,0,0]);

so2data2.avgtime = so2data.avgtime;
so2data2.avgtime_cdt = so2data.avgtime_cdt;
so2data2.filtavgso2 = so2data.filtavgso2;

clear so2data so2info

%% Carbon Monoxide and Nitrous Oxide
[codata, coinfo] = ARM_CDF_Import('E:\Google Drive\Projects\HI-SCALE SGP\Data\ARM_Data\CO');

% co_badbits = [1,2,3,18];
co_badbits = [1:12,18];

for cobits_idx = 1:length(co_badbits)
	codata.co_dry(bitget(codata.qc_co_dry, ones(size(codata.qc_co_dry)) .* co_badbits(cobits_idx)) == 1) = NaN;
	codata.n2o_dry(bitget(codata.qc_n2o_dry, ones(size(codata.qc_n2o_dry)) .* co_badbits(cobits_idx)) == 1) = NaN;
	
end

codata.n2o_dry(codata.time < 900) = NaN;

[codata.avgtime,codata.avgco] = RollingAverage(codata.realtime,codata.co_dry,3600); %CO data looks good without averaging
[~,codata.avgn2o] = RollingAverage(codata.realtime,codata.n2o_dry,3600); %N2O data looks best with 1 hr averaging

codata.avgtime_cdt = datetime(datevec(codata.avgtime) - [0,0,0,5,0,0]);
codata.realtime_cdt = datetime(datevec(codata.realtime) - [0,0,0,5,0,0]);

codata2.avgtime = codata.avgtime;
codata2.avgtime_cdt = codata.avgtime_cdt;
codata2.avgn2o = codata.avgn2o;
codata2.co_dry = codata.co_dry;
codata2.realtime_cdt = codata.realtime_cdt;

clear codata coinfo

%% Plotting them all together

figure;
maxfig(gcf,1);
% set(gca,'FontSize',20,'FontWeight','bold');

trgas_hax = tight_subplot(2,2,[0.0,0.01],[0.08,0.01],[0.06,0.01]);

pos1 = get(trgas_hax(1),'Position');
pos2 = get(trgas_hax(2),'Position');
pos3 = get(trgas_hax(3),'Position');
pos4 = get(trgas_hax(4),'Position');

% for hax_idx = 1:4
% 	set(trgas_hax(hax_idx),'Position',[topleftpos(1), botrightpos(2), botrightpos(1)+botrightpos(3)-topleftpos(1), topleftpos(2)+topleftpos(4)-botrightpos(2)])
% 		
% end

axes(trgas_hax(1));
plot(ozonedata2.avgtime_cdt, ozonedata2.avgo3filt,'Color',[0.2, 0.6, 0.2],'LineWidth',2);
ylabel('O_3 Concentration (ppb)','Color',[0.2, 0.6, 0.2]);
ylim([5,65]);

axes(trgas_hax(2));
plot(so2data2.avgtime_cdt, so2data2.filtavgso2,'Color',[0.6, 0.3, 0.6]);
ylabel('SO_2 Concentration (ppb)','Color',[0.6, 0.3, 0.6]);
ylim([0,1.8]);

hiscale_addrainpatch('cdt');

axes(trgas_hax(3));
plot(codata2.avgtime_cdt, codata2.avgn2o.*1000,'Color',[0.0, 0.0, 0.8],'LineWidth',3);
ylabel('N_2O Mixing Ratio (ppb)','Color',[0.0, 0.0, 0.8]);
ylim([325,335]);

axes(trgas_hax(4));
plot(codata2.realtime_cdt, codata2.co_dry.*1000,'Color',[0.0, 0.0, 0.0]);
ylabel('CO Mixing Ratio (ppb)','Color',[0.0, 0.0, 0.0]);
ylim([0,1500]);

hiscale_addrainpatch('cdt');

set(trgas_hax(1),'Position',[pos1(1), pos1(2), pos2(1)+pos2(3)-pos1(1), pos1(4)],'XTick',[]);
set(trgas_hax(2),'Position',[pos1(1), pos1(2), pos2(1)+pos2(3)-pos1(1), pos1(4)],'XTick',[],'YTick',[0.5,1,1.5]);
set(trgas_hax(3),'Position',[pos3(1), pos3(2), pos4(1)+pos4(3)-pos3(1), pos3(4)],'XTick',[],'YTick',[326,328,330,332,334]);
set(trgas_hax(4),'Position',[pos3(1), pos3(2), pos4(1)+pos4(3)-pos3(1), pos3(4)]);

trgas_hax(4).XTick = [...
	datetime(datevec('04-26-2016 00:00:00')),...
	datetime(datevec('04-28-2016 00:00:00')),...
	datetime(datevec('04-30-2016 00:00:00')),...
	datetime(datevec('05-02-2016 00:00:00')),...
	datetime(datevec('05-04-2016 00:00:00')),...
	datetime(datevec('05-06-2016 00:00:00')),...
	datetime(datevec('05-08-2016 00:00:00')),...
	datetime(datevec('05-10-2016 00:00:00')),...
	datetime(datevec('05-12-2016 00:00:00')),...
	datetime(datevec('05-14-2016 00:00:00')),...
	datetime(datevec('05-16-2016 00:00:00')),...
	datetime(datevec('05-18-2016 00:00:00'))];


set(trgas_hax,'Color','none','FontSize',20,'FontWeight','bold','Box','off',...
	'XLim',[datetime([2016,04,26,00,00,00]), datetime([2016,05,19,00,00,00])]);

set(trgas_hax(1),'YColor',[0.2, 0.6, 0.2]);
set(trgas_hax(2),'YColor',[0.6, 0.3, 0.6]);
set(trgas_hax(3),'YColor',[0.0, 0.0, 0.8]);
set(trgas_hax(4),'YColor',[0.0, 0.0, 0.0]);

set(trgas_hax([1,3]),'YTick',[],'YLabel',[]);
% set(trgas_hax([2,4]),'YTick',[],'YLabel',[]);

annotation('textbox',[0.92,0.90,0.1,0.1],'FitBoxToText','on','String','a)','LineStyle','none','FontSize',20,'FontWeight','bold');
annotation('textbox',[0.92,0.44,0.1,0.1],'FitBoxToText','on','String','b)','LineStyle','none','FontSize',20,'FontWeight','bold');
